********************************************************************************
*Project: 		More Clarification, Less Item Nonresponse in Establishment Surveys? A Split-Ballot Experiment
*Author: 		Benjamin Küfner, Joseph W. Sakshaug, Stefan Zins
*Titel Do-File: Data Processing
*Final Date: 	06.05.2021
********************************************************************************

////////////////////////////////////////////////////////////////////////////////
*1. Log-File and Dataset - CHECK
////////////////////////////////////////////////////////////////////////////////
cap log close
log using "${log_path}/Data_Processing.log", replace

* LOAD EXPERIMENTAL DATA
use "${orig_path}/2019q4_data_complete_experiment_not_cleaned_v2_20200305.dta", clear
merge 1:1 f1 using "${SE_path}/IABSE-Q4123-Greg_2019_experiment_korrigiert.dta", nogenerate keepusing (wz* gebiet04 gk5)

////////////////////////////////////////////////////////////////////////////////
*2. Generate Experimental Indicator - CHECK
////////////////////////////////////////////////////////////////////////////////
encode experiment, generate(exp)
recode exp (2=0)
la var exp "Treatment vs. Controlgroup"
la def exp 1"Treatment" 0"Control", replace
la val exp exp

////////////////////////////////////////////////////////////////////////////////
*3. Rename Item Duration Variables - CHECK
////////////////////////////////////////////////////////////////////////////////
ren Dauer_F35 duration_zf7
ren Dauer_F36 duration_zf5
ren Dauer_F37 duration_zf6
ren Dauer_F38 duration_zf4

gen duration_hiring = duration_zf7 + duration_zf6 + duration_zf5+ duration_zf4

////////////////////////////////////////////////////////////////////////////////
*4. Generate Date Variables - CHECK
////////////////////////////////////////////////////////////////////////////////
foreach var in 7 5 6 4 {
	gen zf`var'_final=.b
	format zf`var'_final %d
	replace zf`var'_final = zf`var' if exp ==0
	replace zf`var'_final = zfea`var' if exp ==1
	}

////////////////////////////////////////////////////////////////////////////////
*5. Generate Item-non-Response Indicator - CHECK
////////////////////////////////////////////////////////////////////////////////
*Single Items
foreach var in zf7 zf5 zf6 zf4  {
replace `var'_final=.b if einst ==5 | einst ==.			
gen INR_`var' =0
recode INR_`var' (0=1) if `var'_final ==. 
replace INR_`var' =. if `var'_final ==.b
}

*1+ Missing
gen INR_one_rec =0
replace INR_one_rec =1 if INR_zf7 ==1 | INR_zf5 ==1 | INR_zf6==1
replace INR_one_rec =. if INR_zf7 == .

*All Missing
gen INR_all_rec =0
replace INR_all_rec =1 if INR_zf7 ==1 & INR_zf5 ==1 & INR_zf6==1 
replace INR_all_rec =. if INR_zf7 == .


*Follow-Up Questions
foreach var in z2x z3x_1 zf16 zf16b zf16c zf187 zf181 zf182_1 zf8 z12n zf171e_1 {
replace `var'=.b if einst ==5 | einst ==.			
gen INR_`var' =0
recode INR_`var' (0=1) if `var' ==. 
replace INR_`var' =. if `var' ==.b
}


////////////////////////////////////////////////////////////////////////////////
*6. Generate Data Quality Indicator - CHECK
////////////////////////////////////////////////////////////////////////////////
foreach var in zf4 zf5 zf6 zf7 {
gen poor_quality_`var' =0
replace poor_quality_`var' =1 if `var'_final > se6 
replace poor_quality_`var' =. if `var'_final ==. |einst !=1
}
 
gen poor_quality_one =0
replace poor_quality_one =1 if poor_quality_zf5 ==1 | poor_quality_zf6 ==1  
replace poor_quality_one =. if (zf5_final ==. & zf6_final ==.)| einst !=1

gen poor_quality_all =0
replace poor_quality_all =1 if poor_quality_zf5 ==1 & poor_quality_zf6 ==1 
replace poor_quality_all =. if zf5_final ==. | zf6_final ==. |  einst !=1

////////////////////////////////////////////////////////////////////////////////
*7. Generate Establishment Size Variable - CHECK
////////////////////////////////////////////////////////////////////////////////
replace f4= round(f4)

*number of employees coded as for the strata
gen gkb5 = 0
recode gkb5 (0=1) if f4 <10
recode gkb5 (0=2) if f4 >=10 & f4 <20
recode gkb5 (0=3) if f4 >=20 & f4 <50
recode gkb5 (0=4) if f4 >=50 & f4 <250
recode gkb5 (0=5) if f4 >=250 & f4 !=.
recode gkb5 (0=.) if  f4 ==.
la var gkb5 "establishment size - 5 Categories - Version 1"
la def gkb5 1 "<10" 2">=10 & <20" 3">=20 & <50" 4">=50 & <250" 5"f4 >=250"
la val gkb5 gkb5

bys gkb5: sum f4

gen gkb5_2 = 0
recode gkb5_2 (0=1) if f4 <5
recode gkb5_2 (0=2) if f4 >=5 & f4 <10
recode gkb5_2 (0=3) if f4 >=10 & f4 <20
recode gkb5_2 (0=4) if f4 >=20 & f4 <50
recode gkb5_2 (0=5) if f4 >=50 & f4 !=.
recode gkb5_2 (0=.) if  f4 ==.
la var gkb5_2 "establishment size - 5 Categories - Version 2"
la def gkb5_2 1 "<5" 2">=5 & <10" 3" >=10 & <20" 4" >=20 & <50" 5">=50"
la val gkb5_2 gkb5_2

bys gkb5_2: sum f4


////////////////////////////////////////////////////////////////////////////////
*8. Generate Working Council and Collective Agreement Variable - CHECK
////////////////////////////////////////////////////////////////////////////////
gen coll_agree =.
replace coll_agree=1 if f465d==1|f465a_1==1
replace coll_agree=0 if f465e==1
replace coll_agree=2 if f465e==. & f465d==. & f465a_1==.

gen work_council =.
replace work_council =1 if f480 ==1
replace work_council =0 if f480 ==2

////////////////////////////////////////////////////////////////////////////////
*9. Generate Industry Variable - CHECK
////////////////////////////////////////////////////////////////////////////////
gen industry=.
replace industry =1 if wz11==1 |  wz11==2
replace industry =2 if wz11==3 |  wz11==4
replace industry =3 if wz11==5 |  wz11==6
replace industry =4 if wz11==7 |  wz11==8 |  wz11==9  |  wz11==10  
replace industry =5 if wz11==11

la def industry 1 "primary sector" 2 "secondary sector" 3"Logistics and Retail" 4 "Other Services" 5 "Public sector"
la val industry industry

////////////////////////////////////////////////////////////////////////////////
*10. Generate Strata - Variable - CHECK
////////////////////////////////////////////////////////////////////////////////
egen strata =group(gk5 wz11)

////////////////////////////////////////////////////////////////////////////////
*11. Saving Dataset - CHECK
////////////////////////////////////////////////////////////////////////////////
save "${data_path}/item_exper_auf.dta", replace

log close
exit


